/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b0\u00101J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u0004Jb\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001c\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u00a2\u0006\u0004\b#\u0010\u0016J\u0010\u0010$\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\u0004R\u0019\u0010\f\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010%\u001a\u0004\b&\u0010\u0004R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010%\u001a\u0004\b)\u0010\u0004R\u0011\u0010+\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010%R\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010%\u001a\u0004\b,\u0010\u0004R\u0019\u0010\r\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010%\u001a\u0004\b-\u0010\u0004R\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010%\u001a\u0004\b.\u0010\u0004R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010%\u001a\u0004\b/\u0010\u0004\u00a8\u00062"}, d2={"Lorg/jetbrains/exposed/sql/Schema;", "", "", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "component5", "component6", "component7", "name", "authorization", "password", "defaultTablespace", "temporaryTablespace", "quota", "on", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/Schema;", "", "createStatement", "()Ljava/util/List;", "", "cascade", "dropStatement", "(Z)Ljava/util/List;", "other", "equals", "(Ljava/lang/Object;)Z", "exists", "()Z", "", "hashCode", "()I", "setSchemaStatement", "toString", "Ljava/lang/String;", "getAuthorization", "getDdl", "ddl", "getDefaultTablespace", "getIdentifier", "identifier", "getOn", "getPassword", "getQuota", "getTemporaryTablespace", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "exposed-core"})
public final class Schema {
    @NotNull
    private final String name;
    @Nullable
    private final String authorization;
    @Nullable
    private final String password;
    @Nullable
    private final String defaultTablespace;
    @Nullable
    private final String temporaryTablespace;
    @Nullable
    private final String quota;
    @Nullable
    private final String on;

    public Schema(@NotNull String name, @Nullable String authorization, @Nullable String password, @Nullable String defaultTablespace, @Nullable String temporaryTablespace, @Nullable String quota, @Nullable String on) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.authorization = authorization;
        this.password = password;
        this.defaultTablespace = defaultTablespace;
        this.temporaryTablespace = temporaryTablespace;
        this.quota = quota;
        this.on = on;
    }

    public /* synthetic */ Schema(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        if ((n & 0x40) != 0) {
            string7 = null;
        }
        this(string, string2, string3, string4, string5, string6, string7);
    }

    @Nullable
    public final String getAuthorization() {
        return this.authorization;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    public final String getDefaultTablespace() {
        return this.defaultTablespace;
    }

    @Nullable
    public final String getTemporaryTablespace() {
        return this.temporaryTablespace;
    }

    @Nullable
    public final String getQuota() {
        return this.quota;
    }

    @Nullable
    public final String getOn() {
        return this.on;
    }

    @NotNull
    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    public final boolean exists() {
        return DefaultKt.getCurrentDialect().schemaExists(this);
    }

    @NotNull
    public final List<String> createStatement() {
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create schema statement", DefaultKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().createSchema(this));
    }

    @NotNull
    public final List<String> dropStatement(boolean cascade) {
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop schema statement", DefaultKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().dropSchema(this, cascade));
    }

    @NotNull
    public final List<String> setSchemaStatement() {
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support schemas", DefaultKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().setSchema(this));
    }

    private final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.authorization;
    }

    @Nullable
    public final String component3() {
        return this.password;
    }

    @Nullable
    public final String component4() {
        return this.defaultTablespace;
    }

    @Nullable
    public final String component5() {
        return this.temporaryTablespace;
    }

    @Nullable
    public final String component6() {
        return this.quota;
    }

    @Nullable
    public final String component7() {
        return this.on;
    }

    @NotNull
    public final Schema copy(@NotNull String name, @Nullable String authorization, @Nullable String password, @Nullable String defaultTablespace, @Nullable String temporaryTablespace, @Nullable String quota, @Nullable String on) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Schema(name, authorization, password, defaultTablespace, temporaryTablespace, quota, on);
    }

    public static /* synthetic */ Schema copy$default(Schema schema, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string = schema.name;
        }
        if ((n & 2) != 0) {
            string2 = schema.authorization;
        }
        if ((n & 4) != 0) {
            string3 = schema.password;
        }
        if ((n & 8) != 0) {
            string4 = schema.defaultTablespace;
        }
        if ((n & 0x10) != 0) {
            string5 = schema.temporaryTablespace;
        }
        if ((n & 0x20) != 0) {
            string6 = schema.quota;
        }
        if ((n & 0x40) != 0) {
            string7 = schema.on;
        }
        return schema.copy(string, string2, string3, string4, string5, string6, string7);
    }

    @NotNull
    public String toString() {
        return "Schema(name=" + this.name + ", authorization=" + this.authorization + ", password=" + this.password + ", defaultTablespace=" + this.defaultTablespace + ", temporaryTablespace=" + this.temporaryTablespace + ", quota=" + this.quota + ", on=" + this.on + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.authorization == null ? 0 : this.authorization.hashCode());
        result2 = result2 * 31 + (this.password == null ? 0 : this.password.hashCode());
        result2 = result2 * 31 + (this.defaultTablespace == null ? 0 : this.defaultTablespace.hashCode());
        result2 = result2 * 31 + (this.temporaryTablespace == null ? 0 : this.temporaryTablespace.hashCode());
        result2 = result2 * 31 + (this.quota == null ? 0 : this.quota.hashCode());
        result2 = result2 * 31 + (this.on == null ? 0 : this.on.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)schema.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authorization, (Object)schema.authorization)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)schema.password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultTablespace, (Object)schema.defaultTablespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.temporaryTablespace, (Object)schema.temporaryTablespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.quota, (Object)schema.quota)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.on, (Object)schema.on);
    }
}

